-- ***************** "USS Nimitz" ******************************

--   Runways and landing strip for Vinson(Nimitz) in LCS

GT.RunWays =
{     
-- landing strip definition (first in table)
--	VppStartPoint; 					azimuth (degree} 	Length_Vpp; 	Width_Vpp;
	{{-44.54,	19.6, -10.49}, 		350.8641, 			240.0, 			25.0, 		
-- alsArgument, lowGlidePath, slightlyLowGlidePath, onLowerGlidePath, onUpperGlidePath, slightlyHighGlidePath, highGlidePath
	0, 			2.5, 		  		2.8, 					3.0, 			  3.0, 				3.2, 				3.5},
	
	
	
-- runways CVN-77 y-Achse + C-Achse umkehren
	{{54.08,	19.6, 17.01}, 		354.217, 			113.0, 			25.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
	{{49.61,	19.6, -4.40}, 		358.260, 			117.4, 			25.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
	{{-43.11,	19.6, -20.04}, 		354.911, 			137.0, 			25.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
	{{-60.61,	19.6, -31.99}, 		0.0, 				132.52, 		25.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
};

GT.RunWays.RunwaysNumber = #GT.RunWays

GT.TaxiRoutes = 
	-- taxi routes and parking spots in LCS
	--    x				y        z			V_target
{		
	{ -- 1 parking spot
	--{{ 23.0,	19.6,		-20.0},  	3.0},
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-105.0,	19.6,		 24.0},  	3.0},		
		{{-125.0,	19.6,		 14.5}, 	2.0},
		{{-140.0,	19.6,		 22.5}, 	-2.0}
	},
	{ -- 2 parking spot
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-105.0,	19.6,		 24.0},  	3.0},		
		{{-125.0,	19.6,		 11.0}, 	2.0},
		{{-126.0,	19.6,		 25.0}, 	-2.0}
	},
	{ -- 3 parking spot
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-105.0,	19.6,		 24.0},  	3.0},		
		{{-115.0,	19.6,		 11.0}, 	2.0},
		{{-115.0,	19.6,		 26.0}, 	-2.0}
	},
	{ -- 4 parking spot (lift3_1)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-95.0,	19.6,		 23.0},  	3.0},		
		{{-105.5,	19.6,		 14.0}, 	2.0},
		{{-103.5,	19.6,		 32.7}, 	-2.0}
	},
	{ -- 5 parking spot (lift3_2)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-85.0,	19.6,		 23.0},  	3.0},		
		{{-93.5,	19.6,		 14.0}, 	2.0},
		{{-91.7,	19.6,		 32.5}, 	-2.0}
	},
	
	{ -- 6 parking spot (after island)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-70.0,	19.6,		 19.0},  	3.0},		
		{{-77.0,	19.6,		 10.0}, 	2.0},
		{{-77.0,	19.6,		 22.5}, 	-2.0}
	},
	
	{ -- 7 parking spot (island 1)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-55.0,	19.6,		 15.0},  	3.0},		
		{{-71.0,	19.6,		  5.0}, 	2.0},
		{{-66.0,	19.6,		 17.5}, 	-2.0}
	},
	
	{ -- 8 parking spot (island 2)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-45.0,	19.6,		 14.0},  	3.0},		
		{{-60.0,	19.6,		  5.0}, 	2.0},
		{{-56.0,	19.6,		 17.0}, 	-2.0}
	},
	
	{ -- 9 parking spot (island 3)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-40.0,	19.6,		 12.0},  	3.0},		
		{{-50.0,	19.6,		  2.0}, 	2.0},
		{{-46.0,	19.6,		 16.0}, 	-2.0}
	},
	
	{ -- 10 parking spot (lift2_1)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	3.0},
		{{-20.0,	19.6,		 14.0},  	3.0},
		{{-34.0,	19.6,		 10.0}, 	2.0},
		{{-34.0,	19.6,		 33.0}, 	-2.0}
	},
	{ -- 11 parking spot (lift2_2)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 20.0,	19.6,		  10.0},  	2.0},
		--{{-10.0,	19.6,		  7.0},  	2.0},
		{{-21.0,	19.6,		 10.0},  	2.0},
		{{-23.0,	19.6,		 -2.0}, 	2.0},
		{{-22.0,	19.6,		 33.0}, 	-2.0}
	},
	{ -- 12 parking spot (between lift1 and lift2)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{ -6.0,	19.6,		 24.0},  	3.0},
		{{ -6.0,	19.6,		 10.0}, 	2.0},
		{{ -6.0,	19.6,		 32.5}, 	-2.0}
	},
	{ -- 13 parking spot (before lift1 1)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 25.0,	19.6,		 10.0},  	3.0},		
		--{{ 20.0,	19.6,		 25.0}, 	2.0},
		{{ 35.0,	19.6,		 27.0}, 	2.0},
		{{ 52.0,	19.6,		 31.0}, 	-2.0}
	},
	{ -- 14 parking spot (before lift1 2)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		 10.0},  	3.0},		
		{{ 20.0,	19.6,		 25.0}, 	2.0},
		{{ 30.0,	19.6,		 21.0}, 	2.0},
		{{ 35.0,	19.6,		 32.5}, 	-2.0}
	},
	{ -- 15 parking spot (lift1_1)
		{{ 15.0,	19.6,		-19.3},  	3.0},
		{{ 30.0,	19.6,		 10.0},  	2.0},		
		{{ 10.0,	19.6,		  0.0}, 	2.0},
		{{ 10.0,	19.6,		 33.0}, 	-2.0,	3.0*60.0}		-- last number - 3*60sec = 3 minutes for despawn object at this point
	},
	{ -- 16 parking spot (lift1_2)
		{{ 15.0,	19.6,		-19.3},  	3.0},
		{{ 40.0,	19.6,		 10.0},  	2.0},		
		{{ 22.0,	19.6,		 -4.0}, 	2.0},
		{{ 21.0,	19.6,		 33.0}, 	-2.0,	3.0*60.0}		-- last number - 3*60sec = 3 minutes for despawn object at this point
	},	
	--[[{ -- 17 parking spot (6pack 1)
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		  5.0},  	3.0},
		{{-10.0,	19.6,		  7.0},  	2.0},
		{{-25.0,	19.6,		 11.0},  	2.0},
		{{-41.0,	19.6,		  4.0}, 	1.0},
		{{-28.0,	19.6,		 12.0}, 	-2.0}
	},
	
	{ -- 18 parking spot (6pack 2)		
		{{  5.0,	19.6,		-17.8},  	3.0},
		{{ 10.0,	19.6,		 15.0},  	2.0},
		{{-10.0,	19.6,		  9.0},  	2.0},
		{{-25.0,	19.6,		  3.0},  	1.0},		
		{{-10.0,	19.6,		  9.0}, 	-2.0}
	},
	
	{ -- 19 parking spot (6pack 3)
		{{ 15.0,	19.6,		-19.3},  	3.0},
		{{ 35.0,	19.6,		  5.0},  	2.0},
		{{ 17.0,	19.6,		 10.0},  	2.0},
		{{ -3.0,	19.6,		  1.5},  	1.0},		
		{{  4.0,	19.6,		  8.0}, 	-2.0}
	},
	
	{ -- 20 parking spot (6pack 4)
		{{ 15.0,	19.6,		-19.3},  	3.0},
		{{ 35.0,	19.6,		 10.0},  	2.0},
		{{ 18.0,	19.6,		  5.0},  	2.0},
		{{ 12.0,	19.6,		  0.0},  	1.0},		
		{{ 18.0,	19.6,		  6.5}, 	-2.0}
	},]]--
	
}
GT.TaxiRoutes.RoutesNumber = #GT.TaxiRoutes


GT.TaxiForTORoutes = 
	-- taxi routes and parking spots in LCS
	--    x				y        z			V_target
	{		
	{ RunwayIdx = 1, Points =
		{ -- 1 spawn spot(6pack 1) -> catapult 1
			{{ 18.0,	19.6,		    6.5}, 	1.0},
			{{ 12.0,	19.6,		    0.0},  	1.0},
			{{ 5.0,		19.6,		   -4.0},  	1.0},			
			{{ 12.0,	19.6,		  -11.0},  	1.0},
			{{ 20.0,	19.6,		    8.0},  	2.0},
			{{ 41.0,	19.6,		   15.4},  	1.0},
			{{42.177,		19.6, 	 15.193},	1.0}
		}
	},
	{ RunwayIdx = 2, Points =
		{ -- 2 spawn spot(6pack 2) -> catapult 2
			{{   4.0,	19.6,	       8.0}, 	1.0},
			{{  -2.7,	19.6,		   1.5},  	1.0},
			{{  -10.0,	19.6,		  -4.0},  	2.0},
			{{   9.0,	19.6,		 -8.0},  	1.0},
			{{  20.0,	19.6,		  -2.3},  	1.0},
			{{38.475,	19.6, 		  -3.53}, 	1.0}
		}
	},
	{ RunwayIdx = 3, Points =
		{ -- 3 spawn spot(6pack 3) -> catapult 3
			{{-10.0,	19.6,		 10.0},  	1.0},
			{{-25.0,	19.6,		  3.0},  	1.0},
			{{-75.0,	19.6,		 -1.5},		3.0},
			{{-65.0,	19.6,		-16.0},  	2.0},
			{{-55.0,	19.6,		-18.2},  	2.0},
			{{-50.06,	19.6, 		-18.57}, 	1.0}
		}
	},	
	{ RunwayIdx = 4, Points =
		{ -- 4 spawn spot(6pack 4) -> catapult 4
			{{-28.0,	19.6,		 12.0},		3.0},
			{{-41.0,	19.6,		  4.0},		3.0},
			{{-86.0,	19.6,		 -4.7},		2.0},
			{{-87.0,	19.6,		-18.0},		2.0},
			{{-79.0,	19.6,		-27.67},	2.0},
			{{-72.3,	19.6,		-29.9 },	1.0},
			{{-66.0,	19.6, 		-30.28},	1.0}
		}
	},	
	{ RunwayIdx = 1, Points =
		{ -- 5 spawn spot(lift2 p1) -> catapult 1		
			{{-22.0,	19.6,		 31.0},  	2.0},
			{{-22.0,	19.6,		  9.0},  	2.0},
			{{ 20.0,	19.6,		  8.0},  	2.0},
			{{ 41.0,	19.6,		 15.4},  	2.0},
			{{42.177,	19.6, 		 15.193},	1.0}
		}
	},
	{ RunwayIdx = 2, Points =
		{ -- 6 spawn spot(lift2 p2) -> catapult 2
			{{-34.0,	19.6,		 31.0},  	1.0},
			{{-34.0,	19.6,		 10.0},  	2.0},
			{{-10.0,	19.6,		 -3.8},  	2.0},
			{{38.475,	19.6, 		-3.53}, 	1.0}
		}
	},
	{ RunwayIdx = 3, Points =
		{ -- 7 spawn spot(lift4 p1) -> catapult 3	
			{{-95.0,		19.6,		-32.0},		1.0},
			{{-95.0,		19.6,		-15.0},		2.0},
			{{-75.0,		19.6,		-15.5},		2.0},
			{{-65.0,		19.6,		-16.0},  	2.0},
			{{-53.0,		19.6,		-18.9},  	2.0},
			{{-50.06,		19.6, 		-18.57}, 	1.0}
		}
	},
	{ RunwayIdx = 4, Points =
		{ -- 8 spawn spot(lift4 p2) -> catapult 4
			{{-107.0,		19.6,		-32.0},		1.0},
			{{-107.0,		19.6,		-15.0},		2.0},
			{{-95.0,		19.6,		-15.0},		2.0},
			{{-79.0,		19.6,		-27.67},	2.0},
			{{-72.3,		19.6,		-29.9 },	1.0},
			{{-66.0,		19.6, 		-30.28},	1.0}
		}
	},
	{ RunwayIdx = 1, Points =
		{ -- 9 spawn spot(lift3 p1) -> catapult 1
			{{-91.7,		19.6,		 31.0},		1.0},
			{{-91.7,		19.6,		 12.5},		2.0},
			{{-40.0,		19.6,		 -5.2},		3.0},
			{{-25.0,		19.6,		  8.0},		3.0},
			{{ 15.0,		19.6,		  8.0},  	3.0},
			{{ 41.0,		19.6,		 15.4},  	2.0},
			{{42.177,		19.6, 		 15.193},	1.0}
		}
	},
	{ RunwayIdx = 2, Points =
		{ -- 10 spawn spot(lift3 p2) -> catapult 2
			{{-103.5,		19.6,		 31.0},		1.0},
			{{-103.5,		19.6,		 12.7},		2.0},
			{{-60.0,		19.6,		 -4.2},		3.0},
			{{-10.0,		19.6,		 -3.8},  	3.0},
			{{38.475,		19.6, 		-3.53}, 	1.0}
		}
	},
}
GT.TaxiForTORoutes.RoutesForTONumber = #GT.TaxiForTORoutes


GT.HelicopterSpawnTerminal = 
	-- taxi routes and parking spots in LCS
	--    x				y        z			direction
	{		
	{ TerminalIdx = 1, Points =
		{ -- 1 spawn spot
			{{ 135.0,	19.6,		    2.0}, 	0.0}			
		}
	},
	{ TerminalIdx = 2, Points =
		{ -- 2 spawn spot
			{{   100.0,	19.6,	       -8.0}, 	0.0}			
		}
	},
	{ TerminalIdx = 3, Points =
		{ -- 3 spawn spot
			{{49.0,	19.6,		 -30.0},  	0.0}
		}
	},	
	{ TerminalIdx = 4, Points =
		{ -- 4 spawn spot
			{{21.8,	19.6,		 -26.0},		0.0}
		}
	},	
	{ TerminalIdx = 5, Points =
		{ -- 5 spawn spot
			{{-2.0,	19.6,		 -26.0},  	0.0}
		}
	},
	{ TerminalIdx = 6, Points =
		{ -- 6 spawn spot
			{{-25.5,	19.6,		 -26.0},  	0.0}
		}
	},
	{ TerminalIdx = 7, Points =
		{ -- 7 spawn spot
			{{-49.0,		19.6,		-26.0},		0.0}
		}
	},
	{ TerminalIdx = 8, Points =
		{ -- 8 spawn spot
			{{-97.0,		19.6,		-27.7},		0.0}
		}
	},
}
GT.HelicopterSpawnTerminal.TerminalNumber = #GT.HelicopterSpawnTerminal


GT.ArrestingGears =
{
	--[[
	--[example]
	{
		-- coordinates for spools (Left and Right) in LCS:
		-- if connector exists write connector name
		-- else write position coordinates manually  -- [pos] omitted when [connector_name] exists
		Left =	{ connector_name = '',	pos = {xl,yl,zl} },
		Right =	{ connector_name = '',	pos = {xr,yr,zr} }
	},
	--]]
	{
		Left = {	connector_name = 'POINT_TROS_01_01' },
		Right = {	connector_name = 'POINT_TROS_01_02' }
	},
	{
		Left = {	connector_name = 'POINT_TROS_02_01' },
		Right = {	connector_name = 'POINT_TROS_02_02' }
	},
	{
		Left = {	connector_name = 'POINT_TROS_03_01' },
		Right = {	connector_name = 'POINT_TROS_03_02' }
	},
	{
		Left = {	connector_name = 'POINT_TROS_04_01' },
		Right = {	connector_name = 'POINT_TROS_04_02' }
	},
}
GT.ArrestingGears.ArrestingGearsNumber = #GT.ArrestingGears

--[[

GT.Elevators = --Aufzüge
-- ElevatorTypes :	SPAWN	= 0, DESPAWN = 1, BOTH	= 2
-- elevator routes and parking spots in LCS
--    		x				y        z			V_target
{		
	{ 	ElevatorIdx = 1, ElevatorType = 1, TerminalIdx = 1,	Points =
		{ 
			{{ 10.0,	8.45,	 33.0}, 	1.0},
			{{ 10.0,	8.45,	  4.0}, 	1.0},
			{{ 	0.0,	8.45,	 -10.0}, 	1.0}
		}
	},
	{
		ElevatorIdx = 1, ElevatorType = 1, TerminalIdx = 2,	Points =
		{ 
			{{ 21.0,	8.45,	 33.0}, 	1.0},
			{{ 15.0,	8.45,	  0.0}, 	1.0},
			{{ 23.0,	8.45,	 -10.0}, 	1.0}
		}
	},
	{ 
		ElevatorIdx = 2, ElevatorType = 0, TerminalIdx = 1,	Points =
		{ 
			{{ -34.0,	8.45,	 33.0}, 	1.0},
			{{ -34.0,	8.45,	  0.0}, 	1.0},
			{{ -44.0,	8.45,	-5.0}, 	1.0}
		}
	},
	{
		ElevatorIdx = 2, ElevatorType = 0, TerminalIdx = 2,	Points =
		{ 
			{{ -22.0,	8.45,	 33.0}, 	1.0},
			{{ -29.0,	8.45,	  0.0}, 	1.0},
			{{ -12.0,	8.45,	-5.0}, 	1.0}
		}
	},
	{ 
		ElevatorIdx = 3, ElevatorType = 0, TerminalIdx = 1,	Points =
		{ 
			{{ -103.5,	8.45,	 32.7}, 	1.0},
			{{ -103.5,	8.45,	  0.0}, 	1.0},
			{{ -115.0,	8.45,	-5.0}, 	1.0}
		}
	},
	{
		ElevatorIdx = 3, ElevatorType = 0, TerminalIdx = 2, Points =
		{ 
			{{ -91.7,	8.45,	 32.5}, 	1.0},
			{{ -91.7,	8.45,	  0.0}, 	1.0},
			{{ -80.0,	8.45,	-5.0}, 	1.0}
		}
	},
	{ 
		ElevatorIdx = 4, ElevatorType = 0, TerminalIdx = 1, Points =
		{ 
			{{ -103.5,	8.45,	 32.7}, 	1.0},
			{{ -103.5,	8.45,	  0.0}, 	1.0},
			{{ -115.0,	8.45,	-5.0}, 	1.0}
		}
	},
	{
		ElevatorIdx = 4, ElevatorType = 0, TerminalIdx = 2,	Points =
		{ 
			{{ -91.7,	8.45,	 32.5}, 	1.0},
			{{ -91.7,	8.45,	  0.0}, 	1.0},
			{{ -80.0,	8.45,	-5.0}, 	1.0}
		}
	},
}
GT.Elevators.ElevatorsNumber = #GT.Elevators	
]]